// texspec.vs
//
// Standardowe przeksztacenie wierzchokw,
// wiato rozproszone oraz refleksy
// zapis N.H we wsprzdnych tekstury 1D
// do wykorzystania w shaderze fragmentw

uniform vec3 lightPos0;

void main(void)
{
    // przeksztacenia model-widok
    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

    vec3 N = normalize(gl_NormalMatrix * gl_Normal);
    vec4 V = gl_ModelViewMatrix * gl_Vertex;
    vec3 L = normalize(lightPos0 - V.xyz);
    vec3 H = normalize(L + vec3(0.0, 0.0, 1.0));

    // wynik owietlenia wiatem rozproszonym zapisujemy w kolorze podstawowym
    float NdotL = dot(N, L);
    gl_FrontColor = gl_Color * vec4(max(0.0, NdotL));

    // wynik obliczenia (N.H)*8-7 zapisujemy we wsprzdnych tekstury
    float NdotH = max(0.0, dot(N, H) * 8.0 - 7.0);
    gl_TexCoord[0] = vec4(NdotH, 0.0, 0.0, 1.0);
}
